package com.example.sefinsa_app.ui.folios.crear;

import static com.example.sefinsa_app.utilities.BluetoothUtils.mConnectedThread;

import android.annotation.SuppressLint;
import android.app.TimePickerDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.appcompat.app.AlertDialog;
import androidx.fragment.app.Fragment;
import androidx.lifecycle.ViewModelProvider;

import android.text.Editable;
import android.text.InputFilter;
import android.text.Spanned;
import android.text.TextWatcher;
import android.util.Base64;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.AutoCompleteTextView;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;

import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import com.example.sefinsa_app.R;
import com.example.sefinsa_app.api.API;
import com.example.sefinsa_app.controllers.ClienteController;
import com.example.sefinsa_app.controllers.ColocadoraController;
import com.example.sefinsa_app.controllers.FolioController;
import com.example.sefinsa_app.controllers.PoblacionController;
import com.example.sefinsa_app.controllers.RutaController;
import com.example.sefinsa_app.migrations.DatabaseHelper;
import com.example.sefinsa_app.models.Aval;
import com.example.sefinsa_app.models.Colocadora;
import com.example.sefinsa_app.models.Folio;
import com.example.sefinsa_app.models.Poblacion;
import com.example.sefinsa_app.models.Ruta;
import com.example.sefinsa_app.ui.clientes.crear.ClientesCrearViewModel;
import com.example.sefinsa_app.utilities.BluetoothUtils;
import com.example.sefinsa_app.utilities.CurrentFragment;
import com.example.sefinsa_app.utilities.ErrorChecker;
import com.example.sefinsa_app.utilities.Validator;
import com.example.sefinsa_app.utilities.VolleyS;
import com.google.android.gms.location.FusedLocationProviderClient;
import com.google.android.gms.location.LocationServices;
import com.google.android.material.datepicker.CalendarConstraints;
import com.google.android.material.datepicker.MaterialDatePicker;
import com.google.android.material.datepicker.MaterialPickerOnPositiveButtonClickListener;
import com.google.android.material.textfield.TextInputEditText;
import com.google.android.material.textfield.TextInputLayout;
import com.google.gson.Gson;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class CrearFolio extends Fragment {
    private static final String ARG_PARAM1 = "param1";
    private static final String ARG_PARAM2 = "param2";
    private static final Logger log = LoggerFactory.getLogger(CrearFolio.class);

    private String mParam1;
    private String mParam2;

    public CrearFolio() { }

    public static CrearFolio newInstance(String param1, String param2) {
        CrearFolio fragment = new CrearFolio();
        Bundle args = new Bundle();
        args.putString(ARG_PARAM1, param1);
        args.putString(ARG_PARAM2, param2);
        fragment.setArguments(args);
        return fragment;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (getArguments() != null) {
            mParam1 = getArguments().getString(ARG_PARAM1);
            mParam2 = getArguments().getString(ARG_PARAM2);
        }
    }

    Button btnFirmaUsuario;
    Button btnFirmaCliente;
    TextInputEditText etMonto;
    TextView tvMonto;
    ImageView imgFirmaUsuario;
    ImageView imgFirmaCliente;
    Button btnCrearFolio;
    EditText etFecha;
    EditText etHora;
    EditText etConcepto;
    String montoN;

    @Override
    public void onDestroy() {
        super.onDestroy();

        SharedPreferences p = requireActivity().getSharedPreferences("firmas", Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = p.edit();

        editor.remove("firmaCliente");
        editor.remove("firmaUsuario");
        editor.apply();
    }

    @Override
    public void onResume() {
        super.onResume();

        SharedPreferences p = requireActivity().getSharedPreferences("firmas", Context.MODE_PRIVATE);

        String firmaUsuario = p.getString("firmaUsuario", null);
        if (firmaUsuario != null) {
            byte[] decodedBytes = Base64.decode(firmaUsuario, Base64.DEFAULT);
            Bitmap bitmap = BitmapFactory.decodeByteArray(decodedBytes, 0, decodedBytes.length);
            imgFirmaUsuario.setImageBitmap(bitmap);
        }

        String firmaCliente = p.getString("firmaCliente", null);
        if (firmaCliente != null) {
            byte[] decodedBytes = Base64.decode(firmaCliente, Base64.DEFAULT);
            Bitmap bitmap = BitmapFactory.decodeByteArray(decodedBytes, 0, decodedBytes.length);
            imgFirmaCliente.setImageBitmap(bitmap);
        }
    }

    public class DecimalDigitsInputFilter implements InputFilter {
        private final int digitsBeforeZero;
        private final int digitsAfterZero;

        public DecimalDigitsInputFilter(int digitsBeforeZero, int digitsAfterZero) {
            this.digitsBeforeZero = digitsBeforeZero;
            this.digitsAfterZero = digitsAfterZero;
        }

        @Override
        public CharSequence filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
            String newVal = dest.subSequence(0, dstart) + source.toString() + dest.subSequence(dend, dest.length());

            if (newVal.equals(".")) {
                return "0.";
            }

            if (newVal.indexOf('.') != newVal.lastIndexOf('.')) {
                return "";
            }

            if (newVal.startsWith("0") && newVal.length() > 1 && !newVal.startsWith("0.")) {
                return "";
            }

            if (newVal.contains(".")) {
                String[] parts = newVal.split("\\.");
                if (parts[0].length() > digitsBeforeZero) {
                    return "";
                }
                if (parts.length > 1 && parts[1].length() > digitsAfterZero) {
                    return "";
                }
            } else {
                if (newVal.length() > digitsBeforeZero) return "";
            }

            return null;
        }
    }


    public void agregarFolio() {
        if (Validator.fieldValidation(
                   tlFecha, "La fecha es requerida")
                && Validator.fieldValidation(tlHora, "La hora es requerida")
                && Validator.fieldValidation(tlRecibiDe, "El campo Recibi de es requerido")
                && Validator.fieldValidation(tlRuta, "La ruta es requerida")
                && Validator.fieldValidation(tlPoblacion, "La pobalción es requerida")
                && Validator.fieldValidation(tlMonto, "El monto es requerido")
                && Validator.fieldValidation(tlConcepto, "El concepto es requerido")
        ) {
            FolioController fc = new FolioController(getContext());
            String fecha = String.valueOf(etFecha.getText());
            String hora = String.valueOf(etHora.getText());
            String nombre_cliente = String.valueOf(tlRecibiDe.getEditText().getText());
            String ruta = ruta_id;
            String poblacion = fc.getPoblacion(poblacion_id);
            String monto = String.valueOf(Objects.requireNonNull(tlMonto.getEditText()).getText());
            String montoLetra = String.valueOf(tvMonto.getText());
            String concepto = String.valueOf(etConcepto.getText());

            if (Objects.equals(ruta, "") || ruta == null) {
                String rutaTxt = String.valueOf(tlRuta.getEditText().getText());
                String rutaId = fc.verificarRuta(rutaTxt);
                String[] rutaArr = rutaTxt.split(" ");
                if (!iRutas.contains(rutaArr[1])) {
                    AlertDialog.Builder builder = new AlertDialog.Builder(requireActivity());
                    builder.setTitle("Ruta inválida");
                    builder.setMessage("La ruta escrita es inválida.");

                    builder.setPositiveButton("Aceptar", new DialogInterface.OnClickListener() {
                        public void onClick(DialogInterface dialog, int id) {
                            dialog.dismiss();
                        }
                    });

                    AlertDialog dialog = builder.create();
                    dialog.show();
                    return;
                }

                if (Objects.equals(rutaId, "")) {
                    AlertDialog.Builder builder = new AlertDialog.Builder(requireActivity());
                    builder.setTitle("Ruta invalida2");
                    builder.setMessage("La ruta escrita es invalida.");

                    builder.setPositiveButton("Aceptar", new DialogInterface.OnClickListener() {
                        public void onClick(DialogInterface dialog, int id) {
                            dialog.dismiss();
                        }
                    });

                    AlertDialog dialog = builder.create();
                    dialog.show();
                    return;
                } else {
                    ruta = rutaId;
                }
            }

            if (Objects.equals(poblacion, "")  || !poblacion.matches("\\d+")) {
                String poblacionTxt = String.valueOf(Objects.requireNonNull(tlPoblacion.getEditText()).getText());
                String poblacionId = fc.verificarPoblacion(poblacionTxt);
                if (Objects.equals(poblacionId, "") || poblacionId == null) {
                    AlertDialog.Builder builder = new AlertDialog.Builder(requireActivity());
                    builder.setTitle("Población invalida");
                    builder.setMessage("La población escrita es invalida.");

                    builder.setPositiveButton("Aceptar", new DialogInterface.OnClickListener() {
                        public void onClick(DialogInterface dialog, int id) {
                            dialog.dismiss();
                        }
                    });

                    AlertDialog dialog = builder.create();
                    dialog.show();
                    return;
                } else {
                    poblacion = poblacionId;
                }
            }

            SharedPreferences p = requireActivity().getSharedPreferences("firmas", Context.MODE_PRIVATE);
            String firmaUsuario = p.getString("firmaUsuario", null);
            String firmaCliente = p.getString("firmaCliente", null);

            if (firmaCliente == null || firmaUsuario == null) {
                AlertDialog.Builder builder = new AlertDialog.Builder(requireActivity());
                builder.setTitle("Ambas firmas son requeridas");
                builder.setMessage("Faltan una o ambas firmas de ser dibujadas.");

                builder.setPositiveButton("Aceptar", new DialogInterface.OnClickListener() {
                    public void onClick(DialogInterface dialog, int id) {
                        dialog.dismiss();
                    }
                });

                AlertDialog dialog = builder.create();
                dialog.show();
            }
            else {
                try {
                    Folio folio = new Folio(
                            folio_id,
                            fecha,
                            hora,
                            nombre_cliente,
                            ruta,
                            poblacion,
                            monto,
                            montoLetra,
                            concepto,
                            firmaUsuario,
                            firmaCliente
                    );

                    fc.store(folio);

                    try {
                        fc.syncFolio(
                                folio.getId(),
                                folio.getFecha(),
                                folio.getHora(),
                                folio.getCliente_id(),
                                ruta_id,
                                poblacion_id,
                                folio.getMonto(),
                                folio.getMonto_letra(),
                                folio.getConcepto(),
                                folio.getFirma_usuario(),
                                folio.getFirma_cliente()
                        );
                    } catch (Exception e) {
                        Toast.makeText(getContext(), "Error al sincronizar", Toast.LENGTH_SHORT).show();
                    }

                    String finalRuta = ruta;
                    String finalPoblacion = poblacion;
                    new AlertDialog.Builder(getContext())
                            .setTitle("Éxito")
                            .setMessage("El folio se guardó correctamente.")
                            .setPositiveButton("Aceptar", (dialog, which) -> {
                                requireActivity().getSupportFragmentManager().popBackStack();
                            })
                            .setNegativeButton("Imprimir", new DialogInterface.OnClickListener() {
                                @Override
                                public void onClick(DialogInterface dialog, int which) {
                                    byte[] decodedBytes = Base64.decode(folio.getFirma_cliente(), Base64.DEFAULT);
                                    Bitmap bitmapFC = BitmapFactory.decodeByteArray(decodedBytes, 0, decodedBytes.length);

                                    byte[] decodedBytes2 = Base64.decode(folio.getFirma_usuario(), Base64.DEFAULT);
                                    Bitmap bitmapFA = BitmapFactory.decodeByteArray(decodedBytes2, 0, decodedBytes2.length);
                                    if (mConnectedThread == null) {
                                        Toast.makeText(getContext(), "No hay impresora conectada", Toast.LENGTH_SHORT).show();
                                        requireActivity().getSupportFragmentManager().popBackStack();
                                    } else {
                                        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
                                            BluetoothUtils.context = getContext();
                                            BluetoothUtils.printPhoto(R.drawable.credigrup_ticket_3);
                                            try {
                                                FolioController folco = new FolioController(getContext());
                                                String p = folco.getPoblacionA(folio.getPoblacion_id());
                                                BluetoothUtils.printReimpresion(folio, finalRuta, p, nombre_cliente, bitmapFA, bitmapFC);
                                                new AlertDialog.Builder(getContext())
                                                        .setTitle("Imprimir segundo ticket")
                                                        .setNegativeButton("Cancelar", new DialogInterface.OnClickListener() {
                                                            @Override
                                                            public void onClick(DialogInterface dialog, int which) {
                                                                dialog.dismiss();
                                                                requireActivity().getSupportFragmentManager().popBackStack();
                                                            }
                                                        })
                                                        .setPositiveButton("Imprimir", new DialogInterface.OnClickListener() {
                                                            @Override
                                                            public void onClick(DialogInterface dialog, int which) {
                                                                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
                                                                    BluetoothUtils.context = getContext();
                                                                    BluetoothUtils.printPhoto(R.drawable.credigrup_ticket_3);
                                                                    try {
                                                                        BluetoothUtils.printReimpresion(folio, finalRuta, p, nombre_cliente, bitmapFA, bitmapFC);
                                                                        requireActivity().getSupportFragmentManager().popBackStack();
                                                                    } catch (ParseException e) {
                                                                        throw new RuntimeException(e);
                                                                    } catch (IOException e) {
                                                                        throw new RuntimeException(e);
                                                                    }
                                                                }
                                                            }
                                                        }).setCancelable(false).show();
                                            } catch (ParseException e) {
                                                throw new RuntimeException(e);
                                            } catch (IOException e) {
                                                throw new RuntimeException(e);
                                            }
                                        }
                                    }
                                }
                            })
                            .setCancelable(false)
                            .show();

                } catch (Exception e) {
                    Log.d("dberr", "Error: " + e.getMessage());
                }
            }
        } else {
            AlertDialog.Builder builder = new AlertDialog.Builder(requireActivity());
            builder.setTitle("Campos requeridos");
            builder.setMessage("Falta algún campo por llenar.");

            builder.setPositiveButton("Aceptar", new DialogInterface.OnClickListener() { public void onClick(DialogInterface dialog, int id) { dialog.dismiss(); } });

            AlertDialog dialog = builder.create();
            dialog.show();
        }
    }

    TextInputLayout tlRuta;
    TextInputLayout tlPoblacion;
    TextInputLayout tlColocadora;
    TextInputLayout tlMonto;
    TextInputLayout tlConcepto;
    TextInputLayout tlFolio;
    String folio_id;

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {

        SharedPreferences p = requireActivity().getSharedPreferences("firmas", Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = p.edit();

        editor.remove("firmaCliente");
        editor.remove("firmaUsuario");
        editor.apply();

        View view = inflater.inflate(R.layout.fragment_crear_folio, container, false);

        btnFirmaUsuario = view.findViewById(R.id.btnFirmaUsuario);
        btnFirmaCliente = view.findViewById(R.id.btnFirmaCliente);
        etMonto = view.findViewById(R.id.edMonto);
        tvMonto = view.findViewById(R.id.tvMonto);
        imgFirmaUsuario = view.findViewById(R.id.imgFirmaUsuario);
        imgFirmaCliente = view.findViewById(R.id.imgFirmaCliente);
        btnCrearFolio = view.findViewById(R.id.btnAgregarFolio);
        etFecha = view.findViewById(R.id.etFecha);
        etHora = view.findViewById(R.id.etHora);
        etConcepto = view.findViewById(R.id.etConcepto);
        tlRuta = view.findViewById(R.id.tlRuta);
        tlPoblacion = view.findViewById(R.id.tlPoblacion);
        tlMonto = view.findViewById(R.id.tlMonto);
        tlConcepto = view.findViewById(R.id.tlConcepto);
        tlFolio = view.findViewById(R.id.tlFolio);

        btnCrearFolio.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                agregarFolio();
            }
        });

        etMonto.setFilters(new InputFilter[]{new DecimalDigitsInputFilter(9, 2)});

        btnFirmaUsuario.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent intent = new Intent(getActivity(), DibujarFirmaActivity.class);
                intent.putExtra("titulo", "Dibujar firma del administrador");
                startActivity(intent);
            }
        });

        btnFirmaCliente.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent intent = new Intent(getActivity(), DibujarFirmaActivity.class);
                intent.putExtra("titulo", "Dibujar firma de colocadora");
                startActivity(intent);
            }
        });

        etMonto.addTextChangedListener(new TextWatcher() {
            @Override public void beforeTextChanged(CharSequence s, int start, int count, int after) { }
            @Override public void onTextChanged(CharSequence s, int start, int before, int count) { }

            @Override
            public void afterTextChanged(Editable s) {
                String cadena = s.toString();
                montoN = cadena;
                if (cadena.matches(".*\\.\\d+.*")) {
                    String[] partes = cadena.split("\\.");
                    String p1 = Convertir(partes[0].toString(), true);
                    String p2 = Convertir(partes[1].toString(), true);
                    if (Objects.equals(partes[0], "1")) { p1 += "PESO CON "; } else { p1 += "PESOS CON "; }
                    if (Objects.equals(partes[1], "1") || Objects.equals(partes[1], "01")) { p2 = "UN CENTAVO"; } else { p2 += "CENTAVOS"; }
                    tvMonto.setText(p1 + p2);
                } else {
                    String[] partes = cadena.split("\\.");
                    String n = Convertir(partes[0].toString(), true);
                    if (Objects.equals(partes[0], "1")) {
                        n = "UN PESO";
                    } else {
                        n += "PESOS";
                    }
                    tvMonto.setText(n);
                }
                if (cadena.isEmpty()) {
                    tvMonto.setText("");
                }
            }
        });

        return view;
    }

    private final String[] UNIDADES = {"", "uno ", "dos ", "tres ", "cuatro ", "cinco ", "seis ", "siete ", "ocho ", "nueve "};
    private final String[] DECENAS = {"diez ", "once ", "doce ", "trece ", "catorce ", "quince ", "dieciseis ",
            "diecisiete ", "dieciocho ", "diecinueve", "veinte ", "treinta ", "cuarenta ",
            "cincuenta ", "sesenta ", "setenta ", "ochenta ", "noventa "};
    private final String[] CENTENAS = {"", "ciento ", "doscientos ", "trecientos ", "cuatrocientos ", "quinientos ", "seiscientos ",
            "setecientos ", "ochocientos ", "novecientos "};

    public String Convertir(String numero, boolean mayusculas) {
        String literal = "";
        String parte_decimal;
        numero = numero.replace(".", ",");
        if (numero.indexOf(",") == -1) {
            numero = numero + ",00";
        }

        if (Pattern.matches("\\d{1,9},\\d{1,2}", numero)) {
            String Num[] = numero.split(",");
            if (Integer.parseInt(Num[0]) == 0) {
                literal = "cero ";
            } else if (Integer.parseInt(Num[0]) > 999999) {
                literal = getMillones(Num[0]);
            } else if (Integer.parseInt(Num[0]) > 999) {
                literal = getMiles(Num[0]);
            } else if (Integer.parseInt(Num[0]) > 99) {
                literal = getCentenas(Num[0]);
            } else if (Integer.parseInt(Num[0]) > 9) {
                literal = getDecenas(Num[0]);
            } else {
                literal = getUnidades(Num[0]);
            }

            if (mayusculas) {
                return (literal).toUpperCase();
            } else {
                return (literal);
            }
        } else {
            return literal = null;
        }
    }

    private String getUnidades(String numero) {
        String num = numero.substring(numero.length() - 1);
        return UNIDADES[Integer.parseInt(num)];
    }

    private String getDecenas(String num) {
        int n = Integer.parseInt(num);
        if (n < 10) {
            return getUnidades(num);
        } else if (n > 19) {
            String u = getUnidades(num);
            if (u.equals("")) {
                return DECENAS[Integer.parseInt(num.substring(0, 1)) + 8];
            } else {
                return DECENAS[Integer.parseInt(num.substring(0, 1)) + 8] + "y " + u;
            }
        } else {
            return DECENAS[n - 10];
        }
    }

    private String getCentenas(String num) {
        if (Integer.parseInt(num) > 99) {
            if (Integer.parseInt(num) == 100) {
                return "cien ";
            } else {
                return CENTENAS[Integer.parseInt(num.substring(0, 1))] + getDecenas(num.substring(1));
            }
        } else {
            return getDecenas(Integer.parseInt(num) + "");
        }
    }

    private String getMiles(String numero) {
        String c = numero.substring(numero.length() - 3);
        String m = numero.substring(0, numero.length() - 3);
        String n = "";

        if (numero.length() == 4) {
            if (m.equals("1")) {
                return "mil " + getCentenas(c);
            }
        }

        if (Integer.parseInt(m) > 0) {
            n = getCentenas(m);
            return n + "mil " + getCentenas(c);
        } else {
            return "" + getCentenas(c);
        }
    }

    private String getMillones(String numero) {
        String miles = numero.substring(numero.length() - 6);
        String millon = numero.substring(0, numero.length() - 6);
        String n = "";

        int millonInt = Integer.parseInt(millon);

        if (millonInt == 1) {
            n = "un millon ";
        } else if (millonInt > 1) {
            n = getCentenas(millon) + "millones ";
        }

        return n + getMiles(miles);
    }

    private ClientesCrearViewModel mViewModel;

    private Button btnRegistrarCliente, btnUbicacion, btnSubirFotos, btnSubirFotosAval;

    private TextInputLayout tlNombreCliente;
    private TextInputLayout tlTelefonoAval;
    private TextInputLayout tlDireccionAval;
    private TextInputLayout tlOtrasReferenciasAval;
    private TextInputLayout tlGarantiasAval;

    private AutoCompleteTextView rutasAutoCompleteTextView;
    private AutoCompleteTextView poblacionesAutoCompleteTextView;
    private AutoCompleteTextView colocadorasAutoCompleteTextView;
    private AutoCompleteTextView clientesAutoCompleteTextView;

    private VolleyS vs;
    private RequestQueue requestQueue;

    private ArrayList<Ruta> rutas;
    private ArrayAdapter<Ruta> rutasAdapter;

    private ArrayList<Poblacion> poblaciones;
    private ArrayAdapter<Poblacion> poblacionesAdapter;

    private ArrayList<Colocadora> colocadoras;
    private ArrayAdapter<Colocadora> colocadorasAdapter;

    private String ruta_id = "";
    private String poblacion_id = "";
    private String colocadora_id = "";
    private String cliente_id = "";

    private ClienteController clienteController;
    private RutaController rutaController;
    private PoblacionController poblacionController;
    private ColocadoraController colocadoraController;
    private String selectedAval = "";
    private HashMap<String, String> avalMap;

    FusedLocationProviderClient client;

    TextInputLayout tlFecha;
    TextInputLayout tlHora;
    TextInputLayout tlRecibiDe;

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        client = LocationServices
                .getFusedLocationProviderClient(
                        getActivity());

        initElements(view);

        rutas = new ArrayList<Ruta>();
        poblaciones = new ArrayList<Poblacion>();
        colocadoras = new ArrayList<Colocadora>();

        sesion = getActivity().getSharedPreferences("sesion", Context.MODE_PRIVATE);
        getRutas();

        rutasAutoCompleteTextView.setOnItemClickListener(new AdapterView.OnItemClickListener() {

            @RequiresApi(api = Build.VERSION_CODES.N)
            @Override
            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                Ruta ruta = rutasAdapter.getItem(i);
                ruta_id = ruta.getId();

                if (poblacionesAutoCompleteTextView.getText().toString().length() > 0) {
                    poblacionesAutoCompleteTextView.setText("");
                }

                List<Poblacion> poblacionesFiltro = poblaciones.stream().filter(poblacion -> poblacion.getRuta_id().equals(ruta_id)).collect(Collectors.toList());

                poblacionesAdapter = new ArrayAdapter<Poblacion>(requireActivity(), android.R.layout.simple_dropdown_item_1line, poblacionesFiltro);
                poblacionesAutoCompleteTextView.setThreshold(1);
                poblacionesAutoCompleteTextView.setAdapter(poblacionesAdapter);

            }
        });

        getPoblaciones("1");

        rutasAutoCompleteTextView.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) { }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) { }

            @Override
            public void afterTextChanged(Editable s) {
                FolioController fc = new FolioController(getContext());
                if (s.toString().length() > 5) {
                    String rutaId = fc.verificarRuta(String.valueOf(s));

                    for (Ruta ruta : rutas) {
                        if (ruta.getId().equals(rutaId)) {
                            List<Poblacion> poblacionesFiltro = null;
                            if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.N) {
                                poblacionesFiltro = poblaciones.stream().filter(poblacion -> poblacion.getRuta_id().equals(rutaId)).collect(Collectors.toList());
                                poblacionesAdapter = new ArrayAdapter<Poblacion>(requireActivity(), android.R.layout.simple_dropdown_item_1line, poblacionesFiltro);
                                poblacionesAutoCompleteTextView.setThreshold(1);
                                poblacionesAutoCompleteTextView.setAdapter(poblacionesAdapter);
                            }
                        }
                    }
                } else {
                    if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.N) {
                        tlPoblacion.getEditText().setText("");
                        poblacionesAutoCompleteTextView.setThreshold(1);
                        poblacionesAutoCompleteTextView.setAdapter(null);
                    }
                }
            }
        });

        poblacionesAutoCompleteTextView.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @RequiresApi(api = Build.VERSION_CODES.N)
            @Override
            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                Poblacion poblacion = poblacionesAdapter.getItem(i);
                poblacion_id = poblacion.getId();
            }
        });

        configurarAutoCompleteTextView();
        SQLiteDatabase db = new DatabaseHelper(requireContext()).getReadableDatabase();

        llenarAutoComplete(db);
    }
    public static boolean validarVariableGlobal(TextInputLayout textInputLayout, String variableGlobal, String errorMessage) {
        if (variableGlobal == null || variableGlobal.isEmpty()) {
            textInputLayout.setError(errorMessage);
            return false;
        }
        textInputLayout.setError(null);
        return true;
    }

    String empleado_id;

    private void initElements(View view) {

        SharedPreferences sesion = getActivity().getSharedPreferences("sesion", Context.MODE_PRIVATE);
        empleado_id = sesion.getString("id", null);

        FolioController fc = new FolioController(getContext());

        CurrentFragment.fragment = "ClientesCrearFragment";

        tlFecha = view.findViewById(R.id.tlFecha);
        tlHora = view.findViewById(R.id.tlHora);
        tlRecibiDe = view.findViewById(R.id.tlRecibiDe);

        rutasAutoCompleteTextView = view.findViewById(R.id.acRuta);
        poblacionesAutoCompleteTextView = view.findViewById(R.id.acPoblacion);
        colocadorasAutoCompleteTextView = view.findViewById(R.id.acColocadora);
        tlNombreCliente = view.findViewById(R.id.tlNombreCliente);
        clientesAutoCompleteTextView = view.findViewById(R.id.acCrearNombreCliente);

        rutaController = new RutaController(getActivity());
        poblacionController = new PoblacionController(getActivity());
        colocadoraController = new ColocadoraController(getActivity());
        clienteController = new ClienteController(getActivity());

        Calendar calendar = Calendar.getInstance();
        int hour = calendar.get(Calendar.HOUR_OF_DAY);
        int minute = calendar.get(Calendar.MINUTE);

        if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.O) {
            LocalDate today = LocalDate.now();

            String[] pFecha = String.valueOf(today).split("-");
            tlFecha.getEditText().setText(pFecha[2] + "/" + pFecha[1] + "/" + pFecha[0]);
            tlHora.getEditText().setText(String.valueOf(hour + ":" + minute));
        }

        tlFecha.getEditText().setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                MaterialDatePicker.Builder<Long> materialDateBuilder = MaterialDatePicker.Builder.datePicker();
                materialDateBuilder.setTitleText("Fecha");

                CalendarConstraints.Builder constraintsBuilder = new CalendarConstraints.Builder();
                constraintsBuilder.setEnd(MaterialDatePicker.todayInUtcMilliseconds());

                materialDateBuilder.setCalendarConstraints(constraintsBuilder.build());

                MaterialDatePicker<Long> materialDatePicker = materialDateBuilder.build();
                materialDatePicker.show(getChildFragmentManager(), "MATERIAL_DATE_PICKER");

                materialDatePicker.addOnPositiveButtonClickListener(
                    new MaterialPickerOnPositiveButtonClickListener<Long>() {
                        @SuppressLint("SetTextI18n")
                        @Override
                        public void onPositiveButtonClick(Long selection) {
                            TimeZone timeZoneUTC = TimeZone.getDefault();
                            int offsetFromUTC = timeZoneUTC.getOffset(new Date().getTime()) * -1;
                            SimpleDateFormat simpleFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
                            Date date = new Date(selection + offsetFromUTC);

                            if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.O) {
                                LocalDate today = LocalDate.now();
                                Instant instant = date.toInstant();
                                ZoneId zoneId = ZoneId.systemDefault();
                                LocalDate selectedDate = instant.atZone(zoneId).toLocalDate();

                                if (selectedDate.isAfter(today)) {
                                    AlertDialog.Builder builder = new AlertDialog.Builder(getActivity());
                                    builder.setTitle("Fecha invalida");
                                    builder.setMessage("La fecha ingresada no puede ser mayor a la de hoy.");

                                    builder.setPositiveButton("Aceptar", new DialogInterface.OnClickListener() {
                                        public void onClick(DialogInterface dialog, int id) {
                                            dialog.dismiss();
                                        }
                                    });

                                    AlertDialog dialog = builder.create();
                                    dialog.show();
                                }
                                else {
                                    String f = simpleFormat.format(date);
                                    String[] pFecha = f.split("-");
                                    tlFecha.getEditText().setText(pFecha[2] + "/" + pFecha[1] + "/" + pFecha[0]);
                                }
                            }
                        }
                    });
            }
        });

        tlHora.getEditText().setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Calendar calendar = Calendar.getInstance();
                int hour = calendar.get(Calendar.HOUR_OF_DAY);
                int minute = calendar.get(Calendar.MINUTE);

                TimePickerDialog timePickerDialog = new TimePickerDialog(v.getContext(),
                        (timePicker, selectedHour, selectedMinute) -> {
                            String formattedTime = String.format(Locale.getDefault(), "%02d:%02d", selectedHour, selectedMinute);
                            tlHora.getEditText().setText(formattedTime);
                        }, hour, minute, true);

                timePickerDialog.show();
            }
        });

        tlFolio.getEditText().setText(fc.getFirstAvailableFolioId(empleado_id));
        folio_id = fc.getFirstAvailableFolioId(empleado_id);
    }

    @Override
    public void onCreateOptionsMenu(@NonNull Menu menu, @NonNull MenuInflater inflater) {
        super.onCreateOptionsMenu(menu, inflater);
    }
    private List<Aval> obtenerListaAvales() {
        List<Aval> listaAvales = new ArrayList<>();
        DatabaseHelper dbHelper = new DatabaseHelper(requireContext());
        SQLiteDatabase db = dbHelper.getReadableDatabase();

        String sqlQuery = "SELECT * FROM clientes WHERE nombre_completo IS NOT NULL AND nombre_completo != '' ORDER BY nombre_completo ASC";
        Cursor cursor = db.rawQuery(sqlQuery, null);

        if (cursor != null && cursor.moveToFirst()) {
            do {
                Aval aval = new Aval(
                        cursor.getString(cursor.getColumnIndexOrThrow("id")),
                        cursor.getString(cursor.getColumnIndexOrThrow("nombre_completo")),
                        cursor.getString(cursor.getColumnIndexOrThrow("direccion")),
                        cursor.getString(cursor.getColumnIndexOrThrow("telefono")),
                        cursor.getString(cursor.getColumnIndexOrThrow("garantias")),
                        cursor.getString(cursor.getColumnIndexOrThrow("otras_referencias")),
                        cursor.getString(cursor.getColumnIndexOrThrow("ruta_id")),
                        cursor.getString(cursor.getColumnIndexOrThrow("poblacion_id")),
                        cursor.getString(cursor.getColumnIndexOrThrow("colocadora_id"))
                );
                listaAvales.add(aval);
            } while (cursor.moveToNext());

            cursor.close();
        }
        db.close();
        return listaAvales;
    }
    private void configurarAutoCompleteTextView() {
        new CrearFolio.ObtenerAvalesTask().execute();
    }

    private class ObtenerAvalesTask extends AsyncTask<Void, Void, List<Aval>> {
        @Override
        protected List<Aval> doInBackground(Void... voids) {
            List<Aval> listaAvales = obtenerListaAvales();

            listaAvales.sort((aval1, aval2) -> {
                try {
                    int id1 = Integer.parseInt(aval1.getId() != null ? aval1.getId() : "0");
                    int id2 = Integer.parseInt(aval2.getId() != null ? aval2.getId() : "0");
                    return Integer.compare(id2, id1);
                } catch (NumberFormatException e) {
                    return 0;
                }
            });

            Set<String> nombresUnicos = new HashSet<>();
            List<String> nombresAvales = new ArrayList<>();
            for (Aval aval : listaAvales) {
                if (nombresUnicos.add(aval.getNombre_completo())) {
                    nombresAvales.add(aval.getNombre_completo());
                }
            }

            return listaAvales;
        }

        @Override
        protected void onPostExecute(List<Aval> listaAvales) {
            if (listaAvales != null) {
                List<String> nombresAvales = new ArrayList<>();
                Set<String> nombresUnicos = new HashSet<>();

                for (Aval aval : listaAvales) {
                    if (nombresUnicos.add(aval.getNombre_completo())) {
                        nombresAvales.add(aval.getNombre_completo());
                    }
                }

                // Adaptador
                ArrayAdapter<String> adapter = new ArrayAdapter<>(
                        requireContext(),
                        android.R.layout.simple_dropdown_item_1line,
                        nombresAvales
                );
            }
        }
    }

    public List<Map<String, String>> getClientesYDisponibles(SQLiteDatabase db) {
        List<Map<String, String>> clientes = new ArrayList<>();
        List<Map<String, String>> avales = new ArrayList<>();
        List<Map<String, String>> resultado = new ArrayList<>();

        String queryClientes = "SELECT id, nombre_completo, 'cliente' AS tipo " +
                "FROM clientes " +
                "WHERE nombre_completo IS NOT NULL AND TRIM(nombre_completo) != ''";
        Cursor cursorClientes = db.rawQuery(queryClientes, null);
        if (cursorClientes != null) {
            while (cursorClientes.moveToNext()) {
                Map<String, String> registro = new HashMap<>();
                registro.put("id", cursorClientes.getString(0));
                registro.put("nombre_completo", cursorClientes.getString(1).trim().toLowerCase()); // Normalizar nombre
                registro.put("tipo", cursorClientes.getString(2));
                clientes.add(registro);
            }
            cursorClientes.close();
        }

        String queryAvales = "SELECT id, nombre_completo, 'aval' AS tipo " +
                "FROM avales " +
                "WHERE nombre_completo IS NOT NULL AND TRIM(nombre_completo) != ''";
        Cursor cursorAvales = db.rawQuery(queryAvales, null);
        if (cursorAvales != null) {
            while (cursorAvales.moveToNext()) {
                Map<String, String> registro = new HashMap<>();
                registro.put("id", cursorAvales.getString(0));
                registro.put("nombre_completo", cursorAvales.getString(1).trim().toLowerCase()); // Normalizar nombre
                registro.put("tipo", cursorAvales.getString(2));
                avales.add(registro);
            }
            cursorAvales.close();
        }

        Set<String> nombresUnicos = new HashSet<>();

        Set<String> nombresAvales = new HashSet<>();
        for (Map<String, String> aval : avales) {
            nombresAvales.add(aval.get("nombre_completo"));
        }

        for (Map<String, String> cliente : clientes) {
            String nombreCliente = cliente.get("nombre_completo");
            if (!nombresAvales.contains(nombreCliente) && !nombresUnicos.contains(nombreCliente)) {
                resultado.add(cliente);
                nombresUnicos.add(nombreCliente);
            }
        }

        for (Map<String, String> aval : avales) {
            String nombreAval = aval.get("nombre_completo");
            if (!nombresUnicos.contains(nombreAval)) {
                resultado.add(aval);
                nombresUnicos.add(nombreAval);
            }
        }

        return resultado;
    }

    @SuppressLint("StaticFieldLeak")
    private void llenarAutoComplete(SQLiteDatabase db) {
        new AsyncTask<Void, Void, List<Map<String, String>>>() {
            @Override
            protected List<Map<String, String>> doInBackground(Void... voids) {
                return getClientesYDisponibles(db);
            }

            @Override
            protected void onPostExecute(List<Map<String, String>> datos) {
                List<String> nombres = new ArrayList<>();
                Map<String, Map<String, String>> idMap = new HashMap<>();

                for (Map<String, String> registro : datos) {
                    String nombre = registro.get("nombre_completo");
                    if (nombre != null && !nombre.trim().isEmpty()) {
                        nombres.add(nombre);
                        idMap.put(nombre, registro);
                    }
                }
            }
        }.execute();
    }

    private SharedPreferences sesion;
    private ArrayList<String> iRutas;

    public void getRutas() {
        // Obtener el ruta_id de la sesión
        String rutaIdSesion = sesion.getString("rutas", "");
        Log.d("getRutas", "Ruta ID de la sesión: " + rutaIdSesion);

        // Descomponer los IDs de la sesión en una lista
        List<String> rutaIdsSesion = Arrays.asList(rutaIdSesion.split(","));
        Log.d("getRutas", "Ruta IDs de la sesión descompuestos: " + rutaIdsSesion);

        // Verificar si ya tenemos rutas guardadas localmente
        if (rutaController.obtener().size() == 0) {
            Log.d("getRutas", "No se encontraron rutas guardadas localmente. Solicitando desde el servidor.");

            vs = VolleyS.getInstance(this.getContext());
            requestQueue = vs.getRequestQueue();

            JSONObject data = new JSONObject();
            try {
                data.put("func", "rutasActivas");
            } catch (JSONException e) {
                e.printStackTrace();
            }

            JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlRutas, data,
                    new Response.Listener<JSONObject>() {

                        @Override
                        public void onResponse(JSONObject response) {
                            Log.d("getRutas", "Respuesta del servidor: " + response.toString());
                            try {
                                JSONArray data = response.getJSONArray("data");
                                Log.d("getRutas", "Cantidad de rutas recibidas: " + data.length());

                                for (int i = 0; i < data.length(); i++) {
                                    JSONObject obj = data.getJSONObject(i);
                                    Log.d("getRutas", "Ruta JSON recibida: " + obj.toString());

                                    Gson gson = new Gson();
                                    Ruta ruta = gson.fromJson(obj.toString(), Ruta.class);

                                    // Filtrar rutas para que solo se incluyan aquellas con el ruta_id de la sesión
                                    if (rutaIdsSesion.contains(ruta.getId())) {
                                        rutas.add(ruta);
                                        rutaController.nueva(ruta);
                                        Log.d("getRutas", "Ruta añadida: " + ruta.toString());
                                    }
                                }

                                // Crear y configurar el adaptador solo con las rutas filtradas
                                rutasAdapter = new ArrayAdapter<>(getContext(), android.R.layout.simple_dropdown_item_1line, rutas);
                                rutasAutoCompleteTextView.setThreshold(1);
                                rutasAutoCompleteTextView.setAdapter(rutasAdapter);
                                Log.d("getRutas", "Adaptador configurado con " + rutas.size() + " rutas.");
                            } catch (JSONException e) {
                                e.printStackTrace();
                                Log.e("getRutas", "Error al procesar respuesta del servidor: " + e.getMessage());
                            }
                        }
                    }, new Response.ErrorListener() {
                @Override
                public void onErrorResponse(VolleyError error) {
                    Log.e("getRutas", "Error en la solicitud de rutas: " + error.getMessage());
                    ErrorChecker.checker(error, getActivity());
                }
            });

            request.setRetryPolicy(new DefaultRetryPolicy(
                    30000,
                    3,
                    DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

            requestQueue.add(request);
            Log.d("getRutas", "Solicitud enviada al servidor.");
        } else {
            // Recuperar las rutas de la base de datos local y filtrar por los IDs en la sesión
            Log.d("getRutas", "Recuperando rutas guardadas localmente.");
            List<Ruta> rutasGuardadas = rutaController.obtener();
            Log.d("getRutas", "Cantidad de rutas locales encontradas: " + rutasGuardadas.size());

            if (iRutas == null) { iRutas = new ArrayList<>(); }

            for (Ruta ruta : rutasGuardadas) {
                Log.d("getRutas", "Ruta local encontrada: " + ruta.toString());
                // Verificar si el ID de la ruta está en la lista de IDs de la sesión
                if (rutaIdsSesion.contains(ruta.getId())) {
                    rutas.add(ruta);
                    Log.d("getRutas", "Ruta añadida tras filtrar: " + ruta);
                }
            }

            // Crear y configurar el adaptador solo con las rutas filtradas
            rutasAdapter = new ArrayAdapter<>(getContext(), android.R.layout.simple_dropdown_item_1line, rutas);
            rutasAutoCompleteTextView.setThreshold(1);
            rutasAutoCompleteTextView.setAdapter(rutasAdapter);
            Log.d("getRutas", "Adaptador configurado con " + rutas.size() + " rutas locales.");
            Log.d("aweqw", "getRutas: " + rutas.toString());
            for (int i = 0; i < rutas.size(); i++) {
                String r = String.valueOf(rutas.get(i));
                String[] ar = r.split(" ");
                String c = ar[1];
                Log.d("qweqweqw", "getRutas: " + c);
                iRutas.add(c);
            }
            Log.d("irutas", "getRutas: " + iRutas);
        }
    }

    private void getPoblaciones(String ruta_id) {
        if (poblacionController.obtener().size() == 0) {

            vs = VolleyS.getInstance(this.requireActivity());
            requestQueue = vs.getRequestQueue();

            JSONObject data = new JSONObject();
            try {
                data.put("func", "index");
            } catch (JSONException e) {
                e.printStackTrace();
            }

            JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlPoblaciones, data,
                    new Response.Listener<JSONObject>() {
                        @Override
                        public void onResponse(JSONObject response) {
                            try {
                                JSONArray data = (JSONArray) response.get("data");
                                for (int i = 0; i < data.length(); i++) {
                                    JSONObject obj = data.getJSONObject(i);
                                    Gson gson = new Gson();
                                    Poblacion poblacion = gson.fromJson(obj.toString(), Poblacion.class);

                                    poblaciones.add(poblacion);
                                    poblacionController.nueva(poblacion);
                                }
                            } catch (JSONException e) {
                                e.printStackTrace();
                            }
                        }
                    }, new Response.ErrorListener() {
                @Override
                public void onErrorResponse(VolleyError error) {
                    ErrorChecker.checker(error, getActivity());
                }
            });

            request.setRetryPolicy(new DefaultRetryPolicy(
                    30000,
                    DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                    DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

            requestQueue.add(request);
        } else {
            poblaciones = poblacionController.obtener();
        }
    }

    @Override
    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        mViewModel = new ViewModelProvider(this).get(ClientesCrearViewModel.class);
    }
}